<?php

namespace App\Filament\Clusters\Business\Resources\BusinessUnits;

use App\Filament\Clusters\Business\Business;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Pages\CreateBusinessUnit;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Pages\EditBusinessUnit;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Pages\ListBusinessUnits;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Pages\ViewBusinessUnit;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Schemas\BusinessUnitForm;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Schemas\BusinessUnitInfolist;
use App\Filament\Clusters\Business\Resources\BusinessUnits\Tables\BusinessUnitsTable;
use App\Models\BusinessUnit;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessUnitResource extends Resource
{
    protected static ?string $model = BusinessUnit::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedBuildingStorefront;

    protected static ?string $cluster = Business::class;

    protected static ?int $navigationSort = 2;
    protected static ?string $navigationLabel = 'Unit Usaha';
    protected static ?string $title = 'Unit Usaha';
    protected static ?string $breadcrumb = 'Unit Usaha';
    protected static ?string $pluralLabel = 'Unit Usaha';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return BusinessUnitForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return BusinessUnitInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BusinessUnitsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBusinessUnits::route('/'),
            // 'create' => CreateBusinessUnit::route('/create'),
            // 'view' => ViewBusinessUnit::route('/{record}'),
            // 'edit' => EditBusinessUnit::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
