<?php

namespace App\Filament\Clusters\Letters\Resources\IncomingLetters;

use App\Filament\Clusters\Letters\LettersCluster;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Pages\CreateIncomingLetter;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Pages\EditIncomingLetter;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Pages\ListIncomingLetters;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Pages\ViewIncomingLetter;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Schemas\IncomingLetterForm;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Schemas\IncomingLetterInfolist;
use App\Filament\Clusters\Letters\Resources\IncomingLetters\Tables\IncomingLettersTable;
use App\Models\IncomingLetter;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class IncomingLetterResource extends Resource
{
    protected static ?string $model = IncomingLetter::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedInboxArrowDown;

    protected static ?string $cluster = LettersCluster::class;

    protected static ?int $navigationSort = 2;
    protected static ?string $navigationLabel = 'Surat Masuk';
    protected static ?string $title = 'Surat Masuk';
    protected static ?string $breadcrumb = 'Surat Masuk';
    protected static ?string $pluralLabel = 'Surat Masuk';

    protected static ?string $recordTitleAttribute = 'subject';

    public static function form(Schema $schema): Schema
    {
        return IncomingLetterForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return IncomingLetterInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return IncomingLettersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListIncomingLetters::route('/'),
            // 'create' => CreateIncomingLetter::route('/create'),
            // 'view' => ViewIncomingLetter::route('/{record}'),
            // 'edit' => EditIncomingLetter::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
