<?php

namespace App\Filament\Clusters\Letters\Resources\LetterRequests\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class LetterRequestForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('resident_id')
                    ->relationship('resident', 'name')
                    ->label('Pemohon')
                    ->searchable()
                    ->preload()
                    ->required(),

                Select::make('letter_type_id')
                    ->relationship('type', 'name')
                    ->label('Jenis Surat')
                    ->searchable()
                    ->preload()
                    ->required(),

                TextInput::make('purpose')
                    ->label('Keperluan')
                    ->required()
                    ->maxLength(255)
                    ->columnSpanFull(),

                FileUpload::make('requirement_files')
                    ->label('Lampiran Persyaratan')
                    ->multiple()
                    ->directory('requirements')
                    ->image()
                    ->nullable()
                    ->columnSpanFull(),
            ]);
    }
}
