<?php

namespace App\Filament\Clusters\Letters\Resources\LetterTypes;

use App\Filament\Clusters\Letters\LettersCluster;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Pages\CreateLetterType;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Pages\EditLetterType;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Pages\ListLetterTypes;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Pages\ViewLetterType;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Schemas\LetterTypeForm;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Schemas\LetterTypeInfolist;
use App\Filament\Clusters\Letters\Resources\LetterTypes\Tables\LetterTypesTable;
use App\Models\LetterType;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class LetterTypeResource extends Resource
{
    protected static ?string $model = LetterType::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedTag;

    protected static ?string $cluster = LettersCluster::class;

    protected static ?int $navigationSort = 9;
    protected static ?string $navigationLabel = 'Jenis Surat';
    protected static ?string $title = 'Jenis Surat';
    protected static ?string $breadcrumb = 'Jenis Surat';
    protected static ?string $pluralLabel = 'Jenis Surat';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return LetterTypeForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return LetterTypeInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return LetterTypesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListLetterTypes::route('/'),
            // 'create' => CreateLetterType::route('/create'),
            // 'view' => ViewLetterType::route('/{record}'),
            // 'edit' => EditLetterType::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
