<?php

namespace App\Filament\Clusters\Letters\Resources\LetterTypes\Schemas;

use Filament\Forms\Components\TagsInput;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class LetterTypeForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('code')
                    ->label('Kode Surat')
                    ->placeholder('KDS')
                    ->required()
                    ->maxLength(150)
                    ->unique(ignoreRecord: true),

                TextInput::make('name')
                    ->label('Nama Surat')
                    ->placeholder('Nama Surat')
                    ->required()
                    ->maxLength(150),

                TextInput::make('description')
                    ->label('Deskripsi')
                    ->placeholder('Deskripsi singkat...'),

                TagsInput::make('requirements')
                    ->label('Persyaratan')
                    ->placeholder('Tambah persyaratan...')
                    ->suggestions(['KTP', 'KK'])
                    ->reorderable(),
            ]);
    }
}
