<?php

namespace App\Filament\Clusters\Letters\Resources\OutgoingLetters\Schemas;

use App\Models\LetterType;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class OutgoingLetterForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                DatePicker::make('letter_date')
                    ->label('Tanggal Surat')
                    ->default(now()),

                TextInput::make('recipient_name')
                    ->label('Nama Penerima')
                    ->placeholder('Nama Penerima Surat'),

                Textarea::make('recipient_address')
                    ->label('Alamat')
                    ->placeholder('Alamat Penerima Surat')
                    ->rows(3)
                    ->columnSpanFull(),

                Select::make('letter_type_id')
                    ->label('Jenis Surat')
                    ->options(LetterType::pluck('name', 'id'))
                    ->searchable(),

                TextInput::make('subject')
                    ->label('Perihal')
                    ->placeholder('Perihal Surat'),

                RichEditor::make('content')
                    ->label('Isi Surat')
                    ->placeholder('Isi Surat')
                    ->columnSpanFull(),

                FileUpload::make('attachments')
                    ->label('Lampiran')
                    ->multiple()
                    ->directory('outgoing-letters')
                    ->downloadable()
                    ->openable()
                    ->acceptedFileTypes(['application/pdf'])
                    ->columnSpanFull(),
            ]);
    }
}
