<?php

namespace App\Filament\Clusters\Regions\Resources\Communities\Schemas;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class CommunityForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Nama RW')
                    ->placeholder('Nama RW')
                    ->required()
                    ->columnSpan(1),
                Select::make('head_id')
                    ->label('Ketua RW')
                    ->relationship('head', 'name')
                    ->searchable()
                    ->preload()
                    ->nullable()
                    ->columnSpan(1),
                Textarea::make('description')
                    ->label('Deskripsi')
                    ->placeholder('Masukkan deskripsi RW, misalnya luas wilayah, batas, atau keterangan lain')
                    ->nullable()
                    ->columnSpanFull(),
            ]);
    }
}
