<?php

namespace App\Filament\Clusters\Regions\Resources\Hamlets;

use App\Filament\Clusters\Regions\RegionsCluster;
use App\Filament\Clusters\Regions\Resources\Hamlets\Pages\CreateHamlet;
use App\Filament\Clusters\Regions\Resources\Hamlets\Pages\EditHamlet;
use App\Filament\Clusters\Regions\Resources\Hamlets\Pages\ListHamlets;
use App\Filament\Clusters\Regions\Resources\Hamlets\Pages\ViewHamlet;
use App\Filament\Clusters\Regions\Resources\Hamlets\Schemas\HamletForm;
use App\Filament\Clusters\Regions\Resources\Hamlets\Schemas\HamletInfolist;
use App\Filament\Clusters\Regions\Resources\Hamlets\Tables\HamletsTable;
use App\Models\Hamlet;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class HamletResource extends Resource
{
    protected static ?string $model = Hamlet::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::Map;

    protected static ?string $cluster = RegionsCluster::class;

    protected static ?int $navigationSort = 1;
    protected static ?string $navigationLabel = 'Dusun';
    protected static ?string $title = 'Dusun';
    protected static ?string $breadcrumb = 'Dusun';
    protected static ?string $pluralLabel = 'Dusun';

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return HamletForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return HamletInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return HamletsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListHamlets::route('/'),
            // 'create' => CreateHamlet::route('/create'),
            // 'view' => ViewHamlet::route('/{record}'),
            // 'edit' => EditHamlet::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
