<?php

namespace App\Filament\Resources\AssistancePrograms\RelationManagers;

use Filament\Actions\AssociateAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\CreateAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\DissociateAction;
use Filament\Actions\DissociateBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ForceDeleteAction;
use Filament\Actions\ForceDeleteBulkAction;
use Filament\Actions\RestoreAction;
use Filament\Actions\RestoreBulkAction;
use Filament\Actions\ViewAction;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Infolists\Components\TextEntry;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Schemas\Schema;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\TrashedFilter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class RecipientsRelationManager extends RelationManager
{
    protected static string $relationship = 'Recipients';
    protected static ?string $title = 'Penerima Bantuan';
    protected static ?string $label = 'Penerima';
    protected static ?string $pluralLabel = 'Penerima Bantuan';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('resident_id')
                    ->relationship('resident', 'name')
                    ->searchable()
                    ->required()
                    ->preload()
                    ->disabledOn('edit')
                    ->label('Warga')
                    ->columnSpanFull(),
                Textarea::make('notes')
                    ->label('Catatan')
                    ->placeholder('Tulis alasan, keterangan tambahan, atau kondisi penerima di sini...')
                    ->maxLength(500)
                    ->columnSpanFull(),
            ]);
    }

    public function infolist(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('id'),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('id')
            ->columns([
                TextColumn::make('resident.name')
                    ->label('Nama Warga')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('status')
                    ->label('STATUS')
                    ->badge()
                    ->formatStateUsing(fn($state) => match ($state) {
                        0 => 'MENUNGGU',
                        1 => 'DISETUJUI',
                        2 => 'TERSALURKAN',
                        9 => 'DITOLAK',
                        default => 'TIDAK DIKETAHUI',
                    })
                    ->color(fn($state) => match ($state) {
                        0 => 'gray',
                        1 => 'success',
                        2 => 'info',
                        9 => 'danger',
                        default => 'secondary',
                    }),
                TextColumn::make('notes')
                    ->label('Catatan')
                    ->wrap()
                    ->toggleable(),
            ])
            ->filters([
                TrashedFilter::make(),
            ])
            ->headerActions([
                CreateAction::make(),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
                DeleteAction::make(),
                ForceDeleteAction::make(),
                RestoreAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                    ForceDeleteBulkAction::make(),
                    RestoreBulkAction::make(),
                ]),
            ])
            ->modifyQueryUsing(fn(Builder $query) => $query
                ->withoutGlobalScopes([
                    SoftDeletingScope::class,
                ]));
    }
}
