<?php

namespace App\Filament\Resources\NeighborhoodTransactions;

use App\Filament\Resources\NeighborhoodTransactions\Pages\CreateNeighborhoodTransaction;
use App\Filament\Resources\NeighborhoodTransactions\Pages\EditNeighborhoodTransaction;
use App\Filament\Resources\NeighborhoodTransactions\Pages\ListNeighborhoodTransactions;
use App\Filament\Resources\NeighborhoodTransactions\Pages\ViewNeighborhoodTransaction;
use App\Filament\Resources\NeighborhoodTransactions\Schemas\NeighborhoodTransactionForm;
use App\Filament\Resources\NeighborhoodTransactions\Schemas\NeighborhoodTransactionInfolist;
use App\Filament\Resources\NeighborhoodTransactions\Tables\NeighborhoodTransactionsTable;
use App\Models\NeighborhoodTransaction;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use UnitEnum;

class NeighborhoodTransactionResource extends Resource
{
    protected static ?string $model = NeighborhoodTransaction::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::CurrencyDollar;

    protected static ?string $recordTitleAttribute = 'description';

    public static function form(Schema $schema): Schema
    {
        return NeighborhoodTransactionForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return NeighborhoodTransactionInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return NeighborhoodTransactionsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListNeighborhoodTransactions::route('/'),
            // 'create' => CreateNeighborhoodTransaction::route('/create'),
            // 'view' => ViewNeighborhoodTransaction::route('/{record}'),
            // 'edit' => EditNeighborhoodTransaction::route('/{record}/edit'),
        ];
    }

    protected static ?int $navigationSort = 6;
    protected static ?string $navigationLabel = 'Keuangan RT';
    protected static ?string $title = 'Keuangan RT';
    protected static ?string $breadcrumb = 'Keuangan RT';
    protected static ?string $pluralLabel = 'Keuangan RT';
}
