<?php

namespace App\Filament\Resources\NeighborhoodTransactions\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class NeighborhoodTransactionForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('type')
                    ->label('Tipe')
                    ->options([
                        'INCOME' => 'PEMASUKAN',
                        'EXPENSE' => 'PENGELUARAN',
                    ])
                    ->columnSpanFull()
                    ->required(),

                TextInput::make('amount')
                    ->label('Nominal')
                    ->numeric()
                    ->columnSpanFull()
                    ->required(),

                DatePicker::make('date')
                    ->label('Tanggal')
                    ->default(now())
                    ->columnSpanFull()
                    ->required(),

                TextInput::make('description')
                    ->label('Deskripsi')
                    ->maxLength(255)
                    ->columnSpanFull()
                    ->required(),

                FileUpload::make('attachment')
                    ->label('Lampiran')
                    ->directory('transactions/neighborhood')
                    ->image()
                    ->columnSpanFull()
                    ->nullable(),
            ]);
    }
}
