<?php

namespace App\Filament\Resources\NeighborhoodTransactions\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Table;

class NeighborhoodTransactionsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('type')->badge()
                    ->colors([
                        'success' => 'INCOME',
                        'danger' => 'EXPENSE',
                    ]),
                TextColumn::make('amount')->money('idr', true),
                TextColumn::make('date')->date(),
                TextColumn::make('description')->limit(30),
                TextColumn::make('created_at')->since(),
            ])
            ->filters([
                Filter::make('income')->query(fn($query) => $query->where('type', 'INCOME')),
                Filter::make('expense')->query(fn($query) => $query->where('type', 'EXPENSE')),
            ])
            ->recordActions([
                ViewAction::make(),
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('date', 'desc');
    }
}
