<?php

namespace App\Filament\SuperAdmin\Resources\Teams\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class TeamForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('village_id')
                    ->relationship('village', 'name') // pastikan model Team punya relasi `village()`
                    ->required()
                    ->searchable()
                    ->preload()
                    ->unique(ignoreRecord: true),

                TextInput::make('subdomain')
                    ->label('Subdomain')
                    ->unique(ignoreRecord: true),

                TextInput::make('address')
                    ->label('Alamat')
                    ->maxLength(255)
                    ->columnSpanFull(),

                FileUpload::make('logo')
                    ->image()
                    ->directory('logos/teams')
                    ->imageEditor()
                    ->maxSize(2048)
                    ->columnSpanFull(),
            ]);
    }
}
