<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssistanceRecipient extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'program_id',
        'resident_id',
        'status',
        'notes',
        'evidence',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'evidence' => 'array',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function program()
    {
        return $this->belongsTo(AssistanceProgram::class, 'program_id');
    }

    public function resident()
    {
        return $this->belongsTo(Resident::class, 'resident_id');
    }
}
