<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Building extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'code',
        'type_id',
        'address',
        'neighborhood_id',
        'hamlet_id',
        'year_built',
        'note',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    // Relasi ke BuildingType
    public function type()
    {
        return $this->belongsTo(BuildingType::class, 'type_id');
    }

    // Relasi ke RT (neighborhood)
    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class, 'neighborhood_id');
    }

    // Relasi ke RW / Dusun (hamlet)
    public function hamlet()
    {
        return $this->belongsTo(Hamlet::class, 'hamlet_id');
    }

    public function elements()
    {
        return $this->hasOne(BuildingElement::class, 'building_id');
    }

    /*
     * Event hook untuk generate code otomatis
     */
    protected static function booted()
    {
        static::creating(function (Building $building) {
            if (empty($building->code)) {
                $lastCode = self::where('team_id', $building->team_id)
                    ->orderByDesc('id')
                    ->value('code');

                $number = 1;
                if ($lastCode && preg_match('/BDG-(\d+)/', $lastCode, $matches)) {
                    $number = (int) $matches[1] + 1;
                }

                $building->code = 'BDG-' . str_pad($number, 5, '0', STR_PAD_LEFT);
            }
        });
    }
}
