<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Business extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'name',
        'decree_number',
        'decree_date',
        'legal_entity',
        'is_active',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'is_active'   => 'boolean',
        'decree_date' => 'date',
    ];

    protected static function booted(): void
    {
        static::addGlobalScope('team', function (Builder $query) {
            if (auth()->check()) {
                $query->where('team_id', auth()->user()->team_id);
            }
        });
    }

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function units()
    {
        return $this->hasMany(BusinessUnit::class);
    }
}
