<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class BusinessTransaction extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'business_unit_id',
        'transaction_type_id',
        'type',
        'description',
        'amount',
        'transaction_date',
        'reference_number',
        'attachment',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'amount'           => 'decimal:2',
        'transaction_date' => 'date',
        'attachment'       => 'array',
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function unit()
    {
        return $this->belongsTo(BusinessUnit::class, 'business_unit_id');
    }

    public function type()
    {
        return $this->belongsTo(BusinessTransactionType::class, 'transaction_type_id');
    }
}
