<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Community extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'hamlet_id',
        'name',
        'description',
        'head_id',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public $casts = [
        'team_id' => 'integer',
        'hamlet_id' => 'integer',
        'head_id' => 'integer',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function head()
    {
        return $this->belongsTo(Resident::class, 'head_id');
    }

    public function hamlet()
    {
        return $this->belongsTo(Hamlet::class);
    }

    public function neighborhoods()
    {
        return $this->hasMany(Neighborhood::class);
    }

    public function residents()
    {
        return $this->hasMany(Resident::class);
    }
}
