<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Crypt;

class FamilyCard extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'number',
        'number_hash',
        'address',
        'neighborhood_id',
        'head_id',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function setNumberAttribute($value): void
    {
        $this->attributes['number'] = Crypt::encryptString($value);
        $this->attributes['number_hash'] = hash('sha256', $value);
    }

    public function getNumberAttribute($value): ?string
    {
        return Crypt::decryptString($value);
    }

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class);
    }

    public function head()
    {
        return $this->belongsTo(Resident::class, 'head_id');
    }

    public function members()
    {
        return $this->hasMany(FamilyMember::class);
    }

    public function residents()
    {
        return $this->hasManyThrough(Resident::class, FamilyMember::class, 'family_card_id', 'id', 'id', 'resident_id');
    }

    // public function residents()
    // {
    //     return $this->belongsToMany(Resident::class, 'household_members')
    //         ->withPivot('family_relationship_id')
    //         ->withTimestamps();
    // }
}
