<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LetterRequestHistory extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'letter_request_id',
        'status',
        'note',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function request()
    {
        return $this->belongsTo(LetterRequest::class, 'letter_request_id');
    }
}
