<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LetterType extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'code',
        'name',
        'description',
        'requirements',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'requirements' => 'array', // Cast JSON to array
    ];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }
}
