<?php

namespace App\Models;

use App\Models\Traits\Blameable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Crypt;

class Resident extends Model
{
    use SoftDeletes, Blameable;

    protected $fillable = [
        'team_id',
        'hamlet_id',
        'neighborhood_id',
        'name',
        'nik',
        'nik_hash',
        'religion_id',
        'marital_status_id',
        'blood_type_id',
        'occupation_id',
        'education_id',
        'gender_id',
        'photo_path',
        'address',
        'birth_place',
        'birth_date',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'team_id' => 'integer',
        'neighborhood_id' => 'integer',
        'religion_id' => 'integer',
        'marital_status_id' => 'integer',
        'blood_type_id' => 'integer',
        'occupation_id' => 'integer',
        'education_id' => 'integer',
        'birth_date' => 'date',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */
    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }

    public function maritalStatus()
    {
        return $this->belongsTo(MaritalStatus::class);
    }

    public function bloodType()
    {
        return $this->belongsTo(BloodType::class);
    }

    public function occupation()
    {
        return $this->belongsTo(Occupation::class);
    }

    public function education()
    {
        return $this->belongsTo(Education::class);
    }

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Accessors & Mutators
    |--------------------------------------------------------------------------
    */
    public function setNikAttribute($value)
    {
        $this->attributes['nik'] = Crypt::encryptString($value);
        $this->attributes['nik_hash'] = hash('sha256', $value);
    }

    public function getNikAttribute($value)
    {
        return Crypt::decryptString($value);
    }

    public function getAgeAttribute(): ?int
    {
        return $this->birth_date ? $this->birth_date->age : null;
    }
}
