<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('residents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->foreignId('neighborhood_id')->nullable()->constrained('neighborhoods')->cascadeOnDelete();
            $table->string('name');
            $table->text('nik');
            $table->string('nik_hash', 64)->index();
            $table->foreignId('religion_id')->nullable()->constrained('religions');
            $table->foreignId('marital_status_id')->nullable()->constrained('marital_statuses');
            $table->foreignId('blood_type_id')->nullable()->constrained('blood_types');
            $table->foreignId('occupation_id')->nullable()->constrained('occupations');
            $table->foreignId('education_id')->nullable()->constrained('educations');
            $table->foreignId('gender_id')->nullable()->constrained('genders');
            $table->string('photo_path')->nullable();
            $table->string('address')->nullable();
            $table->string('birth_place')->nullable();
            $table->date('birth_date')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('residents');
    }
};
