<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('hamlets', function (Blueprint $table) {
            $table->foreign('head_id')
                ->references('id')
                ->on('residents')
                ->nullOnDelete();
        });

        Schema::table('communities', function (Blueprint $table) {
            $table->foreign('head_id')
                ->references('id')
                ->on('residents')
                ->nullOnDelete();
        });

        Schema::table('neighborhoods', function (Blueprint $table) {
            $table->foreign('head_id')
                ->references('id')
                ->on('residents')
                ->nullOnDelete();
        });

        Schema::table('family_cards', function (Blueprint $table) {
            $table->foreign('head_id')
                ->references('id')
                ->on('residents')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('hamlets', function (Blueprint $table) {
            $table->dropForeign(['head_id']);
        });

        Schema::table('neighborhoods', function (Blueprint $table) {
            $table->dropForeign(['head_id']);
        });

        Schema::table('family_cards', function (Blueprint $table) {
            $table->dropForeign(['head_id']);
        });
    }
};
