<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('businesses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('teams')->cascadeOnDelete();
            $table->string('name');
            $table->string('decree_number')->nullable(); // Nomor SK
            $table->date('decree_date')->nullable(); // Tanggal SK
            $table->string('legal_entity')->nullable(); // PT, CV, Cooperative
            $table->boolean('is_active')->default(true); // status aktif / non aktif
            $table->text('address')->nullable();
            $table->timestamps();
            $table->softDeletes();
            // Blameable
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('businesses');
    }
};
