<?php

namespace Database\Seeders;

use App\Models\AssistanceCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AssistanceCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['team_id' => 1, 'name' => 'BLT DANA DESA', 'description' => 'BANTUAN LANGSUNG TUNAI DANA DESA'],
            ['team_id' => 1, 'name' => 'PKH', 'description' => 'PROGRAM KELUARGA HARAPAN'],
            ['team_id' => 1, 'name' => 'SEMBako', 'description' => 'BANTUAN PANGAN / SEMBAKO'],
            ['team_id' => 1, 'name' => 'BANTUAN PENDIDIKAN', 'description' => 'BANTUAN UNTUK SISWA DAN MAHASISWA'],
            ['team_id' => 1, 'name' => 'BANTUAN KESEHATAN', 'description' => 'BANTUAN OBAT-OBATAN ATAU BIAYA BEROBAT'],
            ['team_id' => 1, 'name' => 'BANTUAN DISABILITAS', 'description' => 'BANTUAN UNTUK PENYANDANG DISABILITAS'],
            ['team_id' => 1, 'name' => 'BANTUAN ANAK YATIM', 'description' => 'BANTUAN UNTUK ANAK YATIM PIATU'],
            ['team_id' => 1, 'name' => 'BANTUAN LANSIA', 'description' => 'BANTUAN UNTUK LANJUT USIA'],
            ['team_id' => 1, 'name' => 'BANTUAN PANGAN NON TUNAI (BPNT)', 'description' => 'BANTUAN PANGAN MELALUI KARTU KELUARGA SEJAHTERA'],
            ['team_id' => 1, 'name' => 'BANTUAN BENCANA', 'description' => 'BANTUAN UNTUK KORBAN BENCANA ALAM'],
        ];

        foreach ($categories as $category) {
            AssistanceCategory::create($category);
        }
    }
}
