<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class IndonesiaRegionSeeder extends Seeder
{
    public function run(): void
    {
        $file = database_path('seeders/sql/wilayah.sql');

        if (!File::exists($file)) {
            $this->command->error("❌ File $file tidak ditemukan!");
            return;
        }

        $this->command->info("🚀 Import data wilayah dari $file...");

        $content = File::get($file);

        // Ambil semua baris INSERT
        preg_match_all("/\('([^']+)','([^']+)'\)/", $content, $matches, PREG_SET_ORDER);

        $total = count($matches);
        $this->command->info("📊 Total data: $total");

        $this->command->getOutput()->progressStart($total);

        foreach ($matches as $match) {
            [$all, $kode, $nama] = $match;
            $nama = strtoupper($nama);
            $id = str_replace('.', '', $kode);

            if (preg_match('/^\d{2}$/', $kode)) {
                DB::table('provinces')->insertOrIgnore([
                    'id' => $id,
                    'name' => $nama,
                ]);
            } elseif (preg_match('/^\d{2}\.\d{2}$/', $kode)) {
                DB::table('regencies')->insertOrIgnore([
                    'id' => $id,
                    'province_id' => substr($id, 0, 2),
                    'name' => $nama,
                ]);
            } elseif (preg_match('/^\d{2}\.\d{2}\.\d{2}$/', $kode)) {
                DB::table('districts')->insertOrIgnore([
                    'id' => $id,
                    'regency_id' => substr($id, 0, 4),
                    'name' => $nama,
                ]);
            } elseif (preg_match('/^\d{2}\.\d{2}\.\d{2}\.\d+$/', $kode)) {
                DB::table('villages')->insertOrIgnore([
                    'id' => $id,
                    'district_id' => substr($id, 0, 6),
                    'name' => $nama,
                ]);
            }

            $this->command->getOutput()->progressAdvance();
        }

        $this->command->getOutput()->progressFinish();
        $this->command->info("✅ Selesai import data wilayah.");
    }
}
