<?php

namespace Database\Seeders;

use App\Models\BloodType;
use App\Models\Education;
use App\Models\FamilyRelationship;
use App\Models\Gender;
use App\Models\MaritalStatus;
use App\Models\Occupation;
use App\Models\Religion;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ResidentReferencesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Educations
        $educations = [
            'Tidak / Belum Sekolah',
            'PAUD / TK',
            'SD',
            'SMP',
            'SMA / SMK',
            'Diploma (D1/D2/D3)',
            'Diploma IV / Sarjana Terapan (D4)',
            'Sarjana (S1)',
            'Magister (S2)',
            'Doktor (S3)',
        ];
        foreach ($educations as $edu) {
            Education::firstOrCreate(['name' => strtoupper($edu)]);
        }

        // Religions
        $religions = ['Islam', 'Kristen', 'Katolik', 'Hindu', 'Buddha', 'Konghucu', 'Lainnya'];
        foreach ($religions as $religion) {
            Religion::firstOrCreate(['name' => strtoupper($religion)]);
        }

        // Marital Status
        $statuses = ['Belum Kawin', 'Kawin', 'Cerai Hidup', 'Cerai Mati', 'Duda', 'Janda'];
        foreach ($statuses as $status) {
            MaritalStatus::firstOrCreate(['name' => strtoupper($status)]);
        }

        // Blood Types
        $bloods = ['A', 'B', 'AB', 'O'];
        foreach ($bloods as $blood) {
            BloodType::firstOrCreate(['name' => strtoupper($blood)]);
        }

        // Occupations
        $occupations = [
            'Belum / Tidak Bekerja',
            'Mengurus Rumah Tangga',
            'Pelajar / Mahasiswa',
            'Pensiunan',
            'PNS',
            'TNI',
            'Polri',
            'Guru / Dosen',
            'Dokter / Tenaga Kesehatan',
            'Pedagang',
            'Petani / Pekebun',
            'Peternak',
            'Nelayan',
            'Buruh Harian Lepas',
            'Buruh Tani / Perkebunan',
            'Karyawan Swasta',
            'Wiraswasta',
            'Sopir / Tukang Ojek',
            'Konstruksi / Tukang Bangunan',
            'Seniman / Artis',
            'Lainnya',
        ];
        foreach ($occupations as $job) {
            Occupation::firstOrCreate(['name' => strtoupper($job)]);
        }

        // Genders
        $genders = ['Laki-laki', 'Perempuan'];
        foreach ($genders as $gender) {
            Gender::firstOrCreate(['name' => strtoupper($gender)]);
        }

        // Family Relationships
        $relationships = [
            'Kepala Keluarga',
            'Suami',
            'Istri',
            'Anak',
            'Menantu',
            'Cucu',
            'Orang Tua',
            'Mertua',
            'Famili Lain',
            'Pembantu',
            'Lainnya',
        ];
        foreach ($relationships as $relationship) {
            FamilyRelationship::firstOrCreate(['name' => strtoupper($relationship)]);
        }
    }
}
