<?php

namespace Database\Seeders;

use App\Models\Team;
use Faker\Factory as Faker;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TeamSeeder extends Seeder
{

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create('id_ID');

        $village = DB::table('villages')
            ->where('id', 'like', '640206%')
            ->inRandomOrder()
            ->first();

        if (!$village) {
            $this->command->info('Tidak ada desa, seeder Team dibatalkan.');
            return;
        }

        Team::updateOrCreate(
            [
                'subdomain' => 'demo',
            ],
            [
                'village_id' => $village->id,
                'address'    => $faker->address,
                'logo'       => null,
                'created_by' => null,
                'updated_by' => null,
            ]
        );

        $this->command->info('Tenant untuk desa berhasil dibuat atau sudah ada sebelumnya.');
    }
}
